(function() {
    tinymce.create('tinymce.plugins.wp_recipe_maker', {
        /**
         * Initializes the plugin, this will be executed after the plugin has been created.
         * This call is done before the editor instance has finished it's initialization so use the onInit event
         * of the editor instance to intercept that event.
         *
         * @param {tinymce.Editor} ed Editor instance that the plugin is initialized in.
         * @param {string} url Absolute URL to where the plugin is located.
         */
        init : function(ed, url) {
            ed.addButton('wp_recipe_maker', {
                title : 'WP Recipe Maker',
                cmd : 'wp_recipe_maker',
                image : url.slice(0, -9) + '/icons/cutlery.svg'
            });

            ed.addCommand('wp_recipe_maker', function() {
                let insertedRecipe = false;

                WPRM_Modal.open( 'menu', {
                    insertCallback: ( shortcode ) => WPRM_Modal.addTextToEditor( shortcode, ed.id ),
                    saveCallback: ( recipe ) => {
                        if ( ! insertedRecipe ) {
                            WPRM_Modal.addTextToEditor( '[wprm-recipe id="' + recipe.id + '"]', ed.id );
                            insertedRecipe = true;
                        } else {
                            WPRM_Modal.refreshEditor( ed.id );
                        }
                    },
                } );
            });
        },

        /**
         * Creates control instances based in the incomming name. This method is normally not
         * needed since the addButton method of the tinymce.Editor class is a more easy way of adding buttons
         * but you sometimes need to create more complex controls like listboxes, split buttons etc then this
         * method can be used to create those.
         *
         * @param {String} n Name of the control to create.
         * @param {tinymce.ControlManager} cm Control manager to use inorder to create new control.
         * @return {tinymce.ui.Control} New control instance or null if no control was created.
         */
        createControl : function(n, cm) {
            return null;
        },

        /**
         * Returns information about the plugin as a name/value array.
         * The current keys are longname, author, authorurl, infourl and version.
         *
         * @return {Object} Name/value array containing information about the plugin.
         */
        getInfo : function() {
            return {
                longname : 'WP Recipe Maker',
                author : 'Bootstrapped Ventures',
                authorurl : 'http://bootstrapped.ventures',
                infourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/example',
                version : "0.1"
            };
        }
    });

    // Register plugin
    tinymce.PluginManager.add( 'wp_recipe_maker', tinymce.plugins.wp_recipe_maker );
})();