<?php
/**
 * Responsible for showing admin notices related to the Premium plugin.
 *
 * @link       https://bootstrapped.ventures
 * @since      9.3.1
 *
 * @package    WP_Recipe_Maker_Premium
 * @subpackage WP_Recipe_Maker_Premium/includes/admin
 */

/**
 * Responsible for showing admin notices related to the Premium plugin.
 *
 * @since      9.3.1
 * @package    WP_Recipe_Maker_Premium
 * @subpackage WP_Recipe_Maker_Premium/includes/admin
 * @author     Brecht Vandersmissen <brecht@bootstrapped.ventures>
 */
class WPRMP_Notices {

	/**
	 * Register actions and filters.
	 *
	 * @since    9.3.1
	 */
	public static function init() {
		add_filter( 'wprm_admin_notices', array( __CLASS__, 'user_ratings_notice' ) );
	}

	/**
	 * Show the user ratings notice.
	 *
	 * @since	9.3.1
	 * @param	array $notices Existing notices.
	 */
	public static function user_ratings_notice( $notices ) {
		$screen = function_exists( 'get_current_screen' ) ? get_current_screen() : false;

		// Only load on manage page.
		if ( $screen && 'wp-recipe-maker_page_wprm_manage' === $screen->id ) {
			if ( WPRM_Settings::get( 'features_user_ratings' ) ) {
				$notices[] = array(
					'id' => 'user_ratings_forced_modal',
					'title' => __( 'User Ratings require Modal Mode now', 'wp-recipe-maker' ),
					'text' => '<p>As warned in our previous updates, Google has clearly indicated that anonymous recipe ratings are on thin ice. To make these star ratings more trustworthy we <a href="https://bootstrapped.ventures/wp-recipe-maker-9-2-0/" target="_blank">introduced Modal Mode for user ratings</a> to make sure visitors do not accidentally vote for your recipes and actually confirm their vote. Modal mode also makes it easier than ever for users to leave a quick written comment along with the rating. <strong>We have now removed the old method, so if you have User Ratings enabled it is automatically using Modal Mode</strong>.</p><p>For now, these votes can still be anonymous, but next updates will likely require more details to make sure recipe ratings can be trusted, both by Google and your visitors.</p><p>If you want, you could already enable the option to always require a comment alongside the rating. That can be done using the "Force visitors to leave a comment" setting on the <a href="' . admin_url( 'admin.php?page=wprm_settings#wprm-settings-group-recipeRatings' ) . '">WP Recipe Maker > Settings > Star Ratings page</a>.</p><p>In general, we do not like taking away options, but we strongly feel like this is a necessary step for the food blogging space as a whole and to make sure your ratings do not become a liability if/when Google decides to take proactive corrective action. WP Recipe Maker reacted quickly with updates to help protect recipe trust. All other commonly used recipes plugins followed our lead and are also phasing out anonymous ratings.</p><p>If you have any further questions about this at all, don\'t hesitate to <a href="mailto:support@bootstrapped.ventures">contact us</a>.</p>',
				);
			}
		}

		return $notices;
	}
}

WPRMP_Notices::init();
