<?php
/*
Plugin Name: Purchased Items Column WooCommerce
Plugin URI: https://wordpress.org/plugins/purchased-items-column-woocommerce/
Description: Display a "Purchased Items" column on the WooCommerce orders page.
Author: pipdig
Author URI: https://www.pipdig.co
Version: 1.7.1
Text Domain: purchased-items-column-woocommerce
License: GPLv2 or later
*/

if (!defined('ABSPATH')) die;

add_action('before_woocommerce_init', function() {
	if (class_exists(\Automattic\WooCommerce\Utilities\FeaturesUtil::class)) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
	}
});


// HPOS
add_filter('woocommerce_shop_order_list_table_columns', function ($columns) {
	
	$new_array = [];
	
	foreach ($columns as $key => $title) {
		if ($key == 'billing_address') {
			$new_array['order_items'] = __('Purchased', 'woocommerce');
		}
		$new_array[$key] = $title;
	}
	
	return $new_array;
	
});

// HPOS
add_action('woocommerce_shop_order_list_table_custom_column', function ($column, $order) {
	
	if ($column == 'order_items') {
		echo '<a href="#" class="show_order_items" data-wc-order="'.$order->get_id().'">'.__('Show items', 'purchased-items-column-woocommerce').'</a><div id="show_order_items_'.$order->get_id().'"></div>';
	}
	
}, 10, 2);

// CPT
add_filter('manage_edit-shop_order_columns', function($columns) {
	
	$new_array = [];
	
	foreach ($columns as $key => $title) {
		if ($key == 'billing_address') {
			$new_array['order_items'] = __('Purchased', 'woocommerce');
		}
		$new_array[$key] = $title;
	}
	
	return $new_array;
	
});

// CPT
add_action('manage_shop_order_posts_custom_column', function($column) {
	
	if ($column == 'order_items') {
		echo '<a href="#" class="show_order_items" data-wc-order="'.get_the_ID().'">'.__('Show items', 'purchased-items-column-woocommerce').'</a><div id="show_order_items_'.get_the_ID().'"></div>';
	}
	
}, 10, 2);


add_action('admin_footer', function() {
	
	if ( (isset($_GET['page']) && $_GET['page'] == 'wc-orders') || (isset($_GET['post_type']) && $_GET['post_type'] == 'shop_order')) {
		
		?>
		<script>
		jQuery(document).ready(function($) {
			
			$(".show_order_items").click(function() {
				
				var thisBtn = $(this);
				
				var order_id =  thisBtn.data('wc-order');
				
				thisBtn.hide();
				
				$('#show_order_items_'+order_id).html('loading...');
				
				var data = {
					'action': 'pipdig_wc_find_products_ajax',
					'sec': <?php echo "'".wp_create_nonce('pipdig_wc_find_products_nonce')."'"; ?>,
					'order_id': order_id
				};
				
				$.post(ajaxurl, data, function(response) {
					
					$('#show_order_items_'+order_id).html(response);
					
				});
				
			});
			
		});
		</script>
		<?php
	}
	
}, 999999);


add_action('wp_ajax_pipdig_wc_find_products_ajax', function() {
	
	check_ajax_referer('pipdig_wc_find_products_nonce', 'sec');
	
	if (!function_exists('wc_get_order')) {
		return;
	}
	
	$output = '';
	
	$order_id = (int) $_POST['order_id'];
	
	$order = wc_get_order($order_id);
	
	if (!$order) {
		wp_die();
	}
	
	foreach ($order->get_items() as $item) {
		
		$product = wc_get_product($item->get_product_id());
		
		$sku_output = '';
		
		if ($product) {
			
			$sku = $product->get_sku();
			
			if ($sku) {
				$sku_output = ' ('.esc_html($sku).')';
			}
			
		}
		
		$output .= absint($item['quantity']).' &times; '.esc_html($item['name']).$sku_output.'<br />';
		
    }
	
	echo $output;
	wp_die();
	
});