<?php
/**
 * Updates
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * GK_Updates Class
 */
class GK_Updates {

	public function __construct() {
		
		add_action( 'wp_loaded', array( $this, 'init' ) );
		
	}

	/**
	 * Hook in methods.
	 */
	public static function init() {

		if (is_admin()) {

			add_filter('site_transient_update_plugins', array(__CLASS__, 'override_plugin_update_locations') );
			add_filter('site_transient_update_themes', array(__CLASS__, 'override_theme_update_locations') );

		}
		
	}

	public static function override_theme_update_locations($value) {
		
		if ( get_option( 'gplkit_plugin_manager_activated' ) == 'Activated' ) {

			$all_themes = wp_get_themes();
			if ($gplkit_themes = get_option('gplkit_themes')) {

				foreach($all_themes as $key => $theme) {
					$theme_author_name = $theme->display( 'Author', FALSE );
					
					if (array_key_exists($theme->Name.'-'.$theme_author_name, $gplkit_themes)) {

						$gplkit_licence_manager = get_option('gplkit_plugin_manager');

						$email = $gplkit_licence_manager['activation_email'];
						$licence_key = $gplkit_licence_manager['api_key'];
						$product_id = 'GplKit%20Plugin%20Manager';
						$instance = get_option('gplkit_plugin_manager_instance');

						$theme_url = 'http://www.gplkit.com/?gk_theme_download=get&theme_id='.$gplkit_themes[$theme->Name.'-'.$theme_author_name]['theme_id'].'&email='.$email.'&licence_key='.$licence_key.'&product_id='.$product_id.'&instance='.$instance.'&request=gplkit_status';
						
				        $obj = new stdClass();
						$obj->theme = $key;
				        $obj->new_version = $gplkit_themes[$theme->Name.'-'.$theme_author_name]['version'];
				        $obj->package = $theme_url;

				        $fallback_url = 'https://www.gplkit.com/';

				        if (version_compare($all_themes[$key]['Version'], $obj->new_version) < 0) {

				    	    $value->response[$key]['new_version'] = $gplkit_themes[$theme->Name.'-'.$theme_author_name]['version'];
				    	    $value->response[$key]['package'] = $theme_url;
				    	    $value->response[$key]['url'] = $fallback_url; // Displays error if missing URL
						}
					}
				}
			}
		}

		return $value;
	}

	public static function override_plugin_update_locations($value) {

		if (get_option('gplkit_plugin_manager_activated') == 'Activated') {
	
			$all_plugins = get_plugins();
	
			if ($gplkit_plugins = get_option('gplkit_plugins')) {
	
				foreach ($all_plugins as $key => $plugin) {
	
					if (array_key_exists($key, $gplkit_plugins)) {
	
						$gplkit_licence_manager = get_option('gplkit_plugin_manager');
	
						$email = $gplkit_licence_manager['activation_email'];
						$licence_key = $gplkit_licence_manager['api_key'];
						$product_id = 'GplKit%20Plugin%20Manager';
						$instance = get_option('gplkit_plugin_manager_instance');
	
						$plugin_url = 'https://www.gplkit.com/?gk_plugin_download=get&plugin_id=' . $gplkit_plugins[$key]['plugin_id'] . '&email=' . $email . '&licence_key=' . $licence_key . '&product_id=' . $product_id . '&instance=' . $instance . '&request=gplkit_status';
	
						$obj = new stdClass;
						$obj->slug = $gplkit_plugins[$key]['plugin_id'];
						$obj->plugin = $key;
						$obj->new_version = $gplkit_plugins[$key]['version'];
						$obj->package = $plugin_url;
	
						if (is_object($value) && property_exists($value, 'response') && version_compare($all_plugins[$key]['Version'], $obj->new_version) < 0) {
							$value->response[$key] = $obj;
						}
	
					}
	
				}
			}
		}
	
		return $value;
	}
	

	public static function get_plugin_catalogue() {

		// Get Plugin Catalogue
		$url = 'https://www.gplkit.com/?gk_plugin_repo=json';
		$request = wp_remote_post( $url, array('timeout' => 30) );

		if( !is_wp_error($request) || wp_remote_retrieve_response_code($request) === 200) {
	    	
	    	$json = json_decode( $request['body'], true );

	    	if( $json !== null ) {
		    	update_option('gplkit_plugins', $json, false);
	    	}
	    	
	    }

	    // Get Theme Catalogue
	    $url = 'https://www.gplkit.com/?gk_theme_repo=json';
		$request = wp_remote_post( $url, array('timeout' => 30) );

		if( !is_wp_error($request) || wp_remote_retrieve_response_code($request) === 200) {
	    	
	    	$json = json_decode( $request['body'], true );

	    	if( $json !== null ) {
		    	update_option('gplkit_themes', $json, false);
	    	}
	    	
	    }

	}


	/**
	 * Hook into Plugins API to display plugin information on update screen
	 * FIX: PREVENT CALL FROM HOOKING INTO ALL PLUGINS
	 */
	public static function gplkit_plugin_info( $result, $action, $args ){

		// do nothing if this is not about getting plugin information
		if( 'plugin_information' !== $action ) {
			return false;
		}

		$plugin_slug = $args->slug; // we are going to use it in many places in this function

		// do nothing if it is not our plugin
		if( $plugin_slug !== $args->slug ) {
			return false;
		}

		// temp fix - Future patch will check array for matching slug in array
		if( !is_numeric($plugin_slug) ) {
			return false;
		}

		$remote_url = wp_remote_get( 'https://www.gplkit.com/?gk_plugin_info=json&plugin='.$plugin_slug, array(
			'timeout' => 10,
			'headers' => array(
				'Accept' => 'application/json'
			) 
		));

		$remote = json_decode( $remote_url['body'] );

		$result = new \stdClass();

		$result->name = $remote[0]->name;
		$result->slug = $remote[0]->slug;
		$result->version = $remote[0]->version;
		// $result->tested = $remote[0]->tested;
		// $result->requires = $remote[0]->requires;
		$result->author = $remote[0]->author;
		$result->author_profile = $remote[0]->author_url;
		// $result->download_link = $remote[0]->base;
		// $result->trunk = $remote[0]->base;
		// $result->requires_php = '5.3';
		// $res->last_updated = $remote[0]->last_updated;
		$result->sections = array(
			'description' => $remote[0]->sections->description,
			// 'changelog' => $remote[0]->sections->changelog,
			// 'installation' => $remote->sections->installation,
		);

		if( !empty( $remote[0]->sections->screenshots ) ) {
			$result->sections['screenshots'] = $remote[0]->sections->screenshots;
		}

		$result->banners = array(
			'low' => 'https://www.gplkit.com/wp-content/uploads/2022/08/gplkit-banner-772x250-1.jpg',
			'high' => 'https://www.gplkit.com/wp-content/uploads/2022/08/gplkit-banner-1544x500-1.jpg'
		);

		return $result;

	}

}

GK_Updates::init();

add_action( 'gplkit_twicedaily_update', array('GK_Updates', 'get_plugin_catalogue'), 10 );
add_filter( 'plugins_api', array('GK_Updates', 'gplkit_plugin_info'), 10, 3 );