<?php

use Hostinger\WpHelper\Utils;

$submenus = self::getMenuSubpages();

?>
    <div class="hsr-overlay"></div>
    <div class="hsr-onboarding-navbar">
        <div class="hsr-mobile-sidebar">
            <div class="hsr-close">
                <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M6.99961 8.04961L1.74961 13.2996C1.59961 13.4496 1.42461 13.5246 1.22461 13.5246C1.02461 13.5246 0.849609 13.4496 0.699609 13.2996C0.549609 13.1496 0.474609 12.9746 0.474609 12.7746C0.474609 12.5746 0.549609 12.3996 0.699609 12.2496L5.94961 6.99961L0.699609 1.74961C0.549609 1.59961 0.474609 1.42461 0.474609 1.22461C0.474609 1.02461 0.549609 0.849609 0.699609 0.699609C0.849609 0.549609 1.02461 0.474609 1.22461 0.474609C1.42461 0.474609 1.59961 0.549609 1.74961 0.699609L6.99961 5.94961L12.2496 0.699609C12.3996 0.549609 12.5746 0.474609 12.7746 0.474609C12.9746 0.474609 13.1496 0.549609 13.2996 0.699609C13.4496 0.849609 13.5246 1.02461 13.5246 1.22461C13.5246 1.42461 13.4496 1.59961 13.2996 1.74961L8.04961 6.99961L13.2996 12.2496C13.4496 12.3996 13.5246 12.5746 13.5246 12.7746C13.5246 12.9746 13.4496 13.1496 13.2996 13.2996C13.1496 13.4496 12.9746 13.5246 12.7746 13.5246C12.5746 13.5246 12.3996 13.4496 12.2496 13.2996L6.99961 8.04961Z"
                          fill="#673DE6"></path>
                </svg>
            </div>
            <div class="hsr-wrapper"></div>
        </div>
        <div class="hsr-onboarding-navbar__wrapper">
            <div class="hsr-logo">
                <svg class="hsr-mobile-logo" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M2.00025 14.046V0.000497794L9.08916 3.78046V10.1086L18.4735 10.1132L25.6774 14.046H2.00025ZM20.3925 8.95058V0L27.6725 3.6859V13.1797L20.3925 8.95058ZM20.3924 26.1177V19.8441L10.9358 19.8375C10.9446 19.8793 3.6123 15.8418 3.6123 15.8418L27.6725 15.9547V30L20.3924 26.1177ZM2 26.1177L2.00025 16.9393L9.08916 21.0683V29.8033L2 26.1177Z" fill="#1D1E20"/>
                </svg>
                <svg width="30" height="30" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M2.00025 14.046V0.000497794L9.08916 3.78046V10.1086L18.4735 10.1132L25.6774 14.046H2.00025ZM20.3925 8.95058V0L27.6725 3.6859V13.1797L20.3925 8.95058ZM20.3924 26.1177V19.8441L10.9358 19.8375C10.9446 19.8793 3.6123 15.8418 3.6123 15.8418L27.6725 15.9547V30L20.3924 26.1177ZM2 26.1177L2.00025 16.9393L9.08916 21.0683V29.8033L2 26.1177Z" fill="#1D1E20"/>
                </svg>
            </div>
            <svg class="hsr-mobile-menu-icon" width="24" height="24" viewBox="0 0 24 24" fill="none"
                 xmlns="http://www.w3.org/2000/svg">
                <path d="M3.75 18C3.5375 18 3.35938 17.9277 3.21563 17.7831C3.07187 17.6385 3 17.4594 3 17.2456C3 17.0319 3.07187 16.8542 3.21563 16.7125C3.35938 16.5708 3.5375 16.5 3.75 16.5H20.25C20.4625 16.5 20.6406 16.5723 20.7844 16.7169C20.9281 16.8615 21 17.0406 21 17.2544C21 17.4681 20.9281 17.6458 20.7844 17.7875C20.6406 17.9292 20.4625 18 20.25 18H3.75ZM3.75 12.75C3.5375 12.75 3.35938 12.6777 3.21563 12.5331C3.07187 12.3885 3 12.2094 3 11.9956C3 11.7819 3.07187 11.6042 3.21563 11.4625C3.35938 11.3208 3.5375 11.25 3.75 11.25H20.25C20.4625 11.25 20.6406 11.3223 20.7844 11.4669C20.9281 11.6115 21 11.7906 21 12.0044C21 12.2181 20.9281 12.3958 20.7844 12.5375C20.6406 12.6792 20.4625 12.75 20.25 12.75H3.75ZM3.75 7.5C3.5375 7.5 3.35938 7.42771 3.21563 7.28313C3.07187 7.13853 3 6.95936 3 6.74563C3 6.53188 3.07187 6.35417 3.21563 6.2125C3.35938 6.07083 3.5375 6 3.75 6H20.25C20.4625 6 20.6406 6.07229 20.7844 6.21687C20.9281 6.36147 21 6.54064 21 6.75437C21 6.96812 20.9281 7.14583 20.7844 7.2875C20.6406 7.42917 20.4625 7.5 20.25 7.5H3.75Z"
                      fill="#36344D"></path>
            </svg>
            <?php
            if (!empty($submenus)) { ?>
                <ul class="hsr-wrapper__list">
                    <?php

                    foreach ($submenus as $index => $submenu) {
                        $page = (isset($_GET['page'])) ? $_GET['page'] : '';

                        $is_active = ($page === $submenu['menu_slug'] || ($page === self::MENU_SLUG && $index === 0));

                        ?>
                        <li
                                class="hsr-list__item <?php echo ($is_active) ? "hsr-active" : ""; ?>"
                        >
                            <a
                                    href="<?php echo menu_page_url($submenu['menu_slug'], false); ?>"
                                    class="<?php echo $submenu['menu_slug']; ?>"
                            >
                                <?php

                                echo $submenu['menu_title'];

                                ?>
                            </a>
                        </li>
                        <?php
                    }

                    ?>
                </ul>
            <?php } ?>

            <?php
            $utils     = new Utils();
            $api_token = Utils::getApiToken();
            ?>
            <div class="hsr-navbar-buttons">
                <?php if (get_site_url()) { ?>
                    <div class="hts-preview-website">
                        <a href="<?php echo esc_url(get_site_url()); ?>" target="_blank" rel="noopener">
                            <?php echo esc_html__('Preview website', 'hostinger-wp-menu-package'); ?>
                        </a>
                    </div>
                <?php } ?>
                <?php if (!empty($api_token)) { ?>
                    <div class="hts-hpanel">
                        <a href="<?php echo esc_url($utils->getHpanelDomainUrl()); ?>" target="_blank" rel="noopener">
                            <?php echo esc_html__('Go to Hostinger', 'hostinger-wp-menu-package'); ?>
                        </a>
                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M2.5 5.24609C2.5 3.72731 3.73122 2.49609 5.25 2.49609H6C6.41421 2.49609 6.75 2.83188 6.75 3.24609C6.75 3.66031 6.41421 3.99609 6 3.99609H5.25C4.55964 3.99609 4 4.55574 4 5.24609V10.6842C4 11.3745 4.55964 11.9342 5.25 11.9342H10.7508C11.4411 11.9342 12.0008 11.3745 12.0008 10.6842V9.99829C12.0008 9.58408 12.3366 9.24829 12.7508 9.24829C13.165 9.24829 13.5008 9.58408 13.5008 9.99829V10.6842C13.5008 12.203 12.2696 13.4342 10.7508 13.4342H5.25C3.73122 13.4342 2.5 12.203 2.5 10.6842V5.24609ZM12 5.05906L8.03033 9.02873C7.73744 9.32162 7.26256 9.32162 6.96967 9.02873C6.67678 8.73583 6.67678 8.26096 6.96967 7.96807L10.9393 3.9984L9 3.9984C8.58579 3.9984 8.25 3.66261 8.25 3.2484C8.25 2.83418 8.58579 2.4984 9 2.4984L12.25 2.4984C12.9404 2.4984 13.5 3.05804 13.5 3.7484V6.9984C13.5 7.41261 13.1642 7.7484 12.75 7.7484C12.3358 7.7484 12 7.41261 12 6.9984V5.05906Z" fill="#673DE6"/>
                        </svg>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
<?php
